<?php
	class Post_Model extends CI_Model
	{
		public function __construct()
		{
			$this->load->database();
		}

		public function get_posts($slug = FALSE, $limit = FALSE, $offset = FALSE)
		{
			if ($limit) {
				$this->db->limit($limit, $offset);
			}

			if($slug === FALSE){
				$this->db->where('status', 1);
				$this->db->where('show_page', 1);
				//$this->db->order_by('posts.id', 'DESC');
				//$this->db->join('categories', 'categories.id = posts.category_id');
				$query = $this->db->get('posts');
				return $query->result_array(); 
			}

			$query = $this->db->get_where('posts', array('slug' => $slug));
			return $query->row_array();
		}
		
		public function get_posts_random($slug = FALSE, $limit = FALSE, $offset = FALSE)
		{
			if ($limit) {
				$this->db->limit($limit, $offset);
			}

			if($slug === FALSE){
				$this->db->where('status', 1);
				$this->db->order_by('posts.id', 'RANDOM');
				//$this->db->join('categories', 'categories.id = posts.category_id');
				$query = $this->db->get('posts');
				return $query->result_array(); 
			}

			$query = $this->db->get_where('posts', array('slug' => $slug));
			return $query->row_array();
		}

		public function create_post($post_image)
		{
			$slug = url_title($this->input->post('title'), "dash", TRUE);

			$data = array(
				'title' => $this->input->post('title'), 
			    'slug' => $slug,
			    'body' => $this->input->post('body'),
			    'category_id' => $this->input->post('category_id'),
			    'post_image' => $post_image,
			    'user_id' => $this->session->userdata('user_id')
			    );
			return $this->db->insert('posts', $data);
		}

		public function delete_post($id)
		{
			$image_file_name = $this->db->select('post_image')->get_where('posts', array('id' => $id))->row()->post_image;
			$cwd = getcwd(); // save the current working directory
			$image_file_path = $cwd."\\assets\\images\\posts\\";
			chdir($image_file_path);
			unlink($image_file_name);
			chdir($cwd); // Restore the previous working directory
			$this->db->where('id', $id);
			$this->db->delete('posts');
			return true;
		}

		public function update_post(){
			$slug = url_title($this->input->post('title'), "dash", TRUE);

			$data = array(
				'title' => $this->input->post('title'), 
			    'slug' => $slug,
			    'body' => $this->input->post('body'),
			    'category_id' => $this->input->post('category_id')
			    );
			$this->db->where('id', $this->input->post('id'));
			return $this->db->update('posts', $data);
		}

		public function get_categories(){
			$this->db->order_by('name');
			$query = $this->db->get('categories');
			return $query->result_array();
		}

		public function get_posts_by_category($category_id){
			$this->db->order_by('posts.id', 'DESC');
			$this->db->join('categories', 'categories.id = posts.category_id');
			$query = $this->db->get_where('posts', array('category_id' => $category_id));
			return $query->result_array(); 
		}

		public function cron_posts()
		{
		    $this->db->limit(9, 0);
			$this->db->where('status', 1);
			$this->db->where('show_page', 1);
			//$this->db->order_by('posts.id', 'DESC');
			//$this->db->join('categories', 'categories.id = posts.category_id');
			$query = $this->db->get('posts');
			$posts =  $query->result_array(); 
			//return $query->result_array(); 
			//echo "<pre>"; print_r($posts); exit;

			foreach($posts as $post){
			    //echo $post['id']; 
				$id = $post['id'];
				$data = array(
    				'show_page' => 0
    			    );
    			$this->db->where('id', $id);
    			$this->db->update('posts', $data);
			}
			echo $id;
			//exit;

			//echo $id;

			
				$this->db->limit(9, 0);			
				$this->db->where('id > ', $id);
				$this->db->where('status', 1);
				//$this->db->where('show_page', 1);
				//$this->db->order_by('posts.id', 'DESC');
				//$this->db->join('categories', 'categories.id = posts.category_id');
				$query1 = $this->db->get('posts');
				$posts1 =  $query1->result_array(); 
				//echo "<pre>"; print_r($posts);
				//echo "<pre>"; print_r($posts1);
				
				foreach($posts1 as $post1){
    				$id1 = $post1['id'];
    				$data1 = array(
        				'show_page' => 1
        			    );
        			$this->db->where('id', $id1);
        			$this->db->update('posts', $data1);
				}
				$posts1Count =  $query1->num_rows();
				//echo $posts1Count;
				//exit;


			if($posts1Count < 9){
			    //echo "g"; exit;
				$p = 9-$posts1Count;
				$this->db->limit($p, 0);			
				//$this->db->where('id > ', $id);
				$this->db->where('status', 1);
				//$this->db->where('show_page', 1);
				//$this->db->order_by('posts.id', 'DESC');
				//$this->db->join('categories', 'categories.id = posts.category_id');
				$query2 = $this->db->get('posts');
				$posts2 =  $query2->result_array(); 
				
				foreach($posts2 as $post2){
    				$id2 = $post2['id'];
    				$data2 = array(
        				'show_page' => 1
        			    );
        			$this->db->where('id', $id2);
        			$this->db->update('posts', $data2);
				}
    			
				//$posts1Count =  $query2->num_rows();
			}

		}
	}